//********************************************************************************
//								     Include
//********************************************************************************
#include  "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
//data定義的變量放在單片機前128字節（0x00~0x7F）地址空間中
//idata定義的變量放在（0x00~0xFF）地址空間中
//xdata定義的變量則是放在單片機片上外部擴展RAM空間中（一般指外部0xF000~0xF1FF空間，具體空間大小因單片機而異，有的單片機沒有外部RAM）

//data定義的變量速度最快，idata次之，xdata較前兩者慢
//常被使用的變數用data/idata宣告; 不常使用的變數用xdata宣告.

idata 	unsigned char 	AdcCount;
// int mdu1;
// int mdu2;
// int mdu3;
// int mdu4;
//********************************************************************************
//								Interrupt_Init
//********************************************************************************
void Interrupt_Init (void){
	EX0 = dIE0;								//External0_ISR interrupt 	0
	IT0 = dIT0;
	ET0 = dITR0;							//Timer0_ISR interrupt 		1
	EX1 = dIE1;								//External1_ISR interrupt 	2
	IT1 = dIT1;
	ET1 = dITR1;							//Timer1_ISR interrupt 		3
	ESP = dIUR;								//Uart_ISR interrupt 		4
	ET2 = dITR2;							//Timer2_ISR interrupt 		5
	OCPSIE = dIOCP;							//OCP_ISR interrupt 		8
	ADCIE = dIADC;							//ADC_ISR interrupt 		9
	MPWMMINIE = dIPWM_min;					//PmwMin_ISR interrupt 		10
	MPWMMAXIE = dIPWM_MAX;					//PmwMax_ISR interrupt 		11
	IICIE = dIIIC;							//IIC_ISR interrupt 		12
	LVDIIE = dILVF;							//LowVoltage_ISR interrupt 	13
	WDTIE = dIWDF;							//WatchDoag_ISR interrupt 	14
	CAPIE = dICAP;							//Cap_ISR interrupt 		15
	
	IP0 = 0x04;								//Interrupt Priority
	IP1 = 0x14;								//Group 2 > 4 = 0 = 1 = 3 = 5(解決UR突波問題)
	
	//		  54 3210
	//ip0	0001 0000
	//ip1	0001 0100
	
	//IP0 = 0x0C;							//Interrupt Priority
	//IP1 = 0x06;							//Group 2 > 3 > 1 > 0
	
	EA = 1;									//Allow interrupt
}
//********************************************************************************
//								     INT0
//********************************************************************************
/*void External0_ISR (void) interrupt 0{
	//P3_3 = 0;
	//EX0 = 0;
}*/
//********************************************************************************
//								     Timer0
//********************************************************************************
void Timer0_ISR (void) interrupt 1{		//1mS
	TH0 = TIMER0_TH;		
	TL0 = TIMER0_TL;
	
	if((FLAG.Current_offset == 0) && (MotorState == M_ADC_INIT)){
		Correction_Current_AD_offset();
	}

	Motor_Control(); 

	#if(dUART_MODE == 1)
		UartCount += Timer1ms;
		if(UartCount >= Timer10ms){
			UartFlag = 1;
			UartCount = 0;
		}
		Uart_Read_Handle();
	#endif

	Timer0Flag = 1;
	Timer0Count += Timer1ms;
	Timer0Count &= 0xFF;
	TF0 = 0;
}
//********************************************************************************
//								     INT1
//********************************************************************************
void External1_ISR (void) interrupt 2{

}
//********************************************************************************
//								     Timer1
//********************************************************************************
void Timer1_ISR (void) interrupt 3{		//10mS
	TH1 = TIMER1_TH;
	TL1 = TIMER1_TL;

//	#if (POWER_LIMIT == 1)
//		if(abs(Vbus_avg - Vbus_avg_old) >= 50){ //28=1v
//			if(vbus_high_sw == 0){
//				vbus_high_sw = 1;
//				Vbus_avg_old = Vbus_avg;
//			}
//		}
//		else
//			Vbus_avg_old = Vbus_avg;
//	#endif

	#if (VSP_TRI == 1)
		Vsp_Fun();
	#endif
	
	Protect_scan();
	Phase_OCP_Protect_Fun();
	
	TF1 = 0;
}
//********************************************************************************
//								     UART
//********************************************************************************
#if (dUART_MODE == 1)
void Uart_ISR (void) interrupt 4{
	if(TI){
		Uart_Send_Buffer();
		TI = 0;
	}
	if(RI){
		Uart_Read_Buffer();
		RI = 0;
	}
}
#endif
//********************************************************************************
//								     Timer2
//********************************************************************************
void Timer2_ISR (void) interrupt 5{	//100uS
	TH2 = TIMER2_TH;//10mS @ 2MHz
	TL2 = TIMER2_TL;
	
	TF2 = 0;
}
//********************************************************************************
//								  OCP interrupt
//********************************************************************************
void OCP_ISR (void) interrupt 8{
	AOCP_Protect_Fun();
}
//********************************************************************************
//								 ADC interrupt
//********************************************************************************
void ADC_ISR (void) interrupt 9{
	AdcCount++;
	if(AdcCount == 1){
		#if((Vbus_Protect == 1) || (POWER_LIMIT == 1))
			Vbus_avg = Adc_Channel(V_BUS_CH);	//3.2us
		#endif
	}
	else if(AdcCount == 2){
		#if(POWER_LIMIT == 1)
			if(FLAG.Current_offset == 1) 
				Ibus_avg = abs(Adc_Channel(I_BUS_CH) - OPA_Offset);
			else 
				Ibus_avg = Adc_Channel(I_BUS_CH);
		#endif
	}
	else if(AdcCount == 3){
			//#if((BEMF_TAILWIND_RES_FUNCTION == 1) || (BEMF_TAILWIND_DIODE_FUNCTION == 1))
				//if((MotorState == M_TAILWIND)||(MotorState == M_IPD))
				//{
						//BmfU = Adc_Channel(4);
			BmfV = Adc_Channel(BEMF_V_CH);
			BmfW = Adc_Channel(BEMF_W_CH);
				//}
			//#endif
	}
	else if(AdcCount == 4){
		#if(VSP_TRI == 1)
			Vsp_avg = Adc_Channel(VSP_CH);
			// Vsp_avg = 1023 - Vsp_avg;
		#endif
	}
	else if(AdcCount == 5){
		#if(Temperature_Protect == 1)
			Temperature_avg = Adc_Channel(TEMPERATURE_CH);
		#endif
		
		// if(FLAG.Current_offset==1)
			AdcCount = 0;
	}
	// else if(AdcCount == 6){
		// AdcCount = 0;
		// Ia_ad_values = Adc_Channel(0);
		// Ib_ad_values = Adc_Channel(1);
	// }
}
//********************************************************************************
//						    PWM_MIN_ISR interrupt
//********************************************************************************
/*void PmwMin_ISR (void) interrupt 10{
	//PwmFlag = 1;
}*/
//********************************************************************************
//						    PWM_MAX_ISR interrupt
//********************************************************************************
void PmwMax_ISR (void) interrupt 11{
	PwmFlag = 1;
	
//16bits * 16bits
	// MD0 = 3; //Multiplicand Low.被乘數
	// MD4 = 8;	 //Multiplicator Low.乘數
	// MD1 = 0; //Multiplicand High.被乘數
	// MD5 = 0;	 //Multiplicator High.乘數
	
	// while ((MD_MODE & 0x10) != 0x10);
	// mdu1 = MD0;
	// mdu2 = MD1;
	
}
//********************************************************************************
//						         IIC interrupt
//********************************************************************************
/*void IIC_ISR (void) interrupt 12{
	if((IICS & 0x08)){				// The data Transmit Interrupt Flag
		IICS &= (~0x08);
	}
	if((IICS & 0x10)){				// The data Receive Interrupt Flag
		IICS &= (~0x10);
	}

	if((IICS & 0x40)){				// The Stop condition Interrupt Flag
		IICS &= (~0x40);
	}
}*/
//********************************************************************************
//						      LowVoltage interrupt
//********************************************************************************
//void LowVoltage_ISR (void) interrupt 13{
	
//}
//********************************************************************************
//						      WatchDoag interrupt
//********************************************************************************
//void WatchDoag_ISR (void) interrupt 14{

//}
//********************************************************************************
//						         CAP interrupt
//********************************************************************************
// void Cap_ISR (void) interrupt 15{

// }
